VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   2700
   ClientLeft      =   2130
   ClientTop       =   1950
   ClientWidth     =   5370
   LinkTopic       =   "Form1"
   ScaleHeight     =   2700
   ScaleWidth      =   5370
   Begin VB.ComboBox DeviceNum 
      Height          =   315
      Left            =   2760
      TabIndex        =   4
      Text            =   "Combo1"
      Top             =   840
      Width           =   975
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   2760
      TabIndex        =   3
      Text            =   "0"
      ToolTipText     =   "Enter Value between 0 and 15"
      Top             =   1440
      Width           =   495
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Write DO Chan 0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1440
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   1320
      Top             =   2040
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   600
      Top             =   2040
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2760
      TabIndex        =   5
      Top             =   480
      Width           =   1935
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit


Private Sub cmdInit_Click()
' read in the device number we should use
Dim devNum As Integer
devNum = CInt(DeviceNum.Text)
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kmb1800" ' give Driver name to avoid Open DriverLINX dialog
.Req_device = devNum      ' use "kmb1700" DriverLINX for DAS-1700 is installed
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' error check

If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
LDD.Req_DLL_name = SR.Req_DLL_name  ' use of the LDD control is not required
LDD.device = SR.Req_device
LDD.Refresh    ' load the LDD with data about our device
Form1.Caption = LDD.Dev_Model   ' get the model number of the device
Else
' an error happened....do message box operation to display error info
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware, in this case the exact model number
Form1.SetFocus  ' set focus back to our form
End Sub

Private Sub cmdSample_Click()
 On Error GoTo TOOBig
SetupDOSingleValue
Dim DOValue As Byte
' read in value to write to the port
DOValue = CByte(Text1.Text)  ' could raise an error here if value typed is bigger than byte
' DAS-1700 have only 4 bits of digital output
' all DAS-1800 except the DAS-180xHC also have only 4 bits of digital output
' assume an 4bit digital channel....between 0 and 15
SR.Res_Sta_ioValue = DOValue
' .Res_Sta_ioValue property can host the single value to be written
SR.Refresh  ' write it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
Exit Sub ' to avoid error handler
TOOBig:
MsgBox "Enter value between 0 and 15", vbOKOnly
Text1.Text = 0  ' set it back to an in range value
Resume
End Sub

Private Sub Form_Load()
' populate the combo box with legal DriverLINX device numbers 0..5
DeviceNum.AddItem "0", 0
DeviceNum.AddItem "1", 1
DeviceNum.AddItem "2", 2
DeviceNum.AddItem "3", 3
DeviceNum.AddItem "4", 4
DeviceNum.AddItem "5", 5
DeviceNum.ListIndex = 0  ' set the combo box equal to the first entry
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupDOSingleValue()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0
End With
End Sub

Sub ConfigureChannelforOutputMode(ByVal chan As Integer)
With SR
.Req_subsystem = DL_DO  ' assign the channel the DL_DO subsystem
.Req_mode = DL_OTHER
.Req_op = DL_CONFIGURE
.Evt_Tim_type = DL_DIOSETUP
.Evt_Tim_dioChannel = chan
.Evt_Tim_dioMode = DL_DIO_BASIC
.Refresh
End With
End Sub
' ISA bus multi function boards such as DAS-1800 typically have a dedicated digital output
' channel.  The code above is not needed for these boards.
' However, many PCI cards such as KPCI-3101 have digital channels that are
' configurable for input or output.  To use these channels as an output, a configure
' operation must first be carried out to assign the channel to the DO subsystem.
' the code above can carry out a configure operation for a requested channel for KPCI
' cards which require this configuration step.
'
' if you do not, then you will get 'invalid channel in channel/gain list' error message

